<?php
// Enable CORS and JSON response
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["status" => "error", "message" => "Only POST method is allowed."]);
    exit;
}

// Get the raw POST data
$input = json_decode(file_get_contents("php://input"), true);

// Validate required fields
if (
    !isset($input['email']) ||
    !isset($input['html']) ||
    !isset($input['subject'])
) {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "Missing required fields: email, subject, html"]);
    exit;
}

$email = $input['email'];
$subject = $input['subject'];
$html = $input['html'];

// SMTP Configuration
require 'vendor/autoload.php'; // Make sure PHPMailer is installed via Composer

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$mail = new PHPMailer(true);

try {
    // SMTP settings
    $mail->isSMTP();
    $mail->Host = 'lasgsafetyreg.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'admin@lasgsafetyreg.com';
    $mail->Password = '!9iUtL?+Yavk';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    $mail->Port = 465;

    // Email settings
    $mail->setFrom('noreply@lasgsafetyreg.com', 'LASG Safety');
    $mail->addAddress($email);
    $mail->isHTML(true);
    $mail->Subject = $subject;
    $mail->Body = $html;
    $mail->AltBody = strip_tags($html);

    // Send email
    $mail->send();
    echo json_encode(["status" => "success", "message" => "Email sent to $email"]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Mailer Error: " . $mail->ErrorInfo,
        "error" => $e->getMessage()
    ]);
}
